/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.engine.test;

import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.interfaces.IDao;
import com.quantumdata.sct.dao.vo.TestResultVO;
import com.quantumdata.sct.dao.vo.TestResultsVO;
import com.quantumdata.sct.dao.vo.TestVO;
import com.quantumdata.sct.engine.test.TestEngineContext;
import com.quantumdata.sct.engine.test.TestResultsPanel;
import com.quantumdata.sct.gui.common.SCTConstants;
import com.quantumdata.sct.gui.wizard.ActivityCardItemPanel;
import com.quantumdata.sct.util.SCTSelection;
import java.awt.Color;

public class TestEngine {
    private TestEngineContext context;
    private boolean isSaved;
    private ActivityCardItemPanel concludePage;

    public TestEngine(TestVO testVO) throws Exception {
        this.context = new TestEngineContext(testVO);
    }

    public ActivityCardItemPanel createTestConcludePage() {
        this.concludePage = new TestResultsPanel(this.context.getTestResultVO(), this.context.getTest());
        this.concludePage.setBackground(Color.white);
        this.concludePage.setName("Test Conclude");
        return this.concludePage;
    }

    public boolean saveTestResult() throws Exception {
        TestResultVO testResultVO = this.context.getTestResultVO();
        testResultVO.evaluateStatus();
        testResultVO.setDirty();
        String string = SCTSelection.instance().getUnitID();
        IDao iDao = XMLDAOFactory.getTestResultsDAO(SCTConstants.getUnitStorage(string));
        TestResultsVO testResultsVO = (TestResultsVO)iDao.read(string);
        testResultsVO.setDirty();
        testResultsVO.update(testResultVO);
        iDao.update(testResultsVO);
        this.isSaved = true;
        if (this.concludePage != null) {
            this.concludePage.preShow();
        }
        return this.isSaved;
    }

    public TestVO getTest() {
        return this.context.getTest();
    }

    public TestEngineContext getContext() {
        return this.context;
    }
}

